/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.I2CSignal;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeConverter {
    public static int IntegerArrayToInt(Integer[] integerArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n3 = (3 - i) * 8;
            n2 += (integerArray[i + n] & 0xFF) << n3;
        }
        return n2;
    }

    public static final long composeLong(Vector<Integer> vector, int n) {
        long l;
        try {
            l = vector.get(n) * 0x1000000 + vector.get(n + 1) * 65536 + vector.get(n + 2) * 256 + vector.get(n + 3);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0L;
        }
        return l;
    }

    public static final long composeLongFromSignals(Vector<I2CSignal> vector, int n) {
        long l;
        try {
            l = vector.get(n).getData() * 0x1000000 + vector.get(n + 1).getData() * 65536 + vector.get(n + 2).getData() * 256 + vector.get(n + 3).getData();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0L;
        }
        return l;
    }

    public static final long composeLong(Integer[] integerArray, int n) {
        long l;
        try {
            l = integerArray[n] * 0x1000000 + integerArray[n + 1] * 65536 + integerArray[n + 2] * 256 + integerArray[n + 3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0L;
        }
        return l;
    }

    public static final int composeIntFromSignals(Vector<I2CSignal> vector, int n) {
        return vector.get(n).getData() * 256 + vector.get(n + 1).getData();
    }

    public static final int composeInt(Integer[] integerArray, int n) {
        return integerArray[n] * 256 + integerArray[n + 1];
    }

    public static final String getDisplayPortTimestampString(long l) {
        long l2 = l;
        long l3 = l2 / 3600000000L;
        long l4 = (l2 -= l3 * 3600000000L) / 60000000L;
        long l5 = (l2 -= l4 * 60000000L) / 1000000L;
        return String.format("%02d:%02d:%02d.%06d", l3, l4, l5, l2 -= l5 * 1000000L);
    }

    public static final String getTimestampString(long l) {
        long l2 = l;
        long l3 = l2 / 3600000000L;
        long l4 = (l2 -= l3 * 3600000000L) / 60000000L;
        long l5 = (l2 -= l4 * 60000000L) / 1000000L;
        l2 -= l5 * 1000000L;
        return String.format("%02d:%02d:%02d.%04d", l3, l4, l5, l2 /= 100L);
    }

    public static final String getTimeString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        double d = (double)(l % 10000L) / 10.0;
        long l2 = l / 10000L % 60L;
        long l3 = l / 600000L % 60L;
        long l4 = l / 36000000L % 24L;
        long l5 = l / 864000000L;
        if (l5 > 0L) {
            stringBuffer.append(l5);
            stringBuffer.append(" days");
            if (l4 > 0L || l3 > 0L || l2 > 0L || d > 0.0) {
                stringBuffer.append(", ");
            }
        }
        if (l4 > 0L) {
            stringBuffer.append(l4);
            stringBuffer.append(" hrs");
            if (l3 > 0L || l2 > 0L || d > 0.0) {
                stringBuffer.append(", ");
            }
        }
        if (l3 > 0L) {
            stringBuffer.append(l3);
            stringBuffer.append(" min");
            if (l2 > 0L || d > 0.0) {
                stringBuffer.append(", ");
            }
        }
        if (l2 > 0L) {
            stringBuffer.append(l2);
            stringBuffer.append(" sec");
            if (d > 0.0) {
                stringBuffer.append(", ");
            }
        }
        if (d > 0.0) {
            stringBuffer.append(d);
            stringBuffer.append(" msec");
        }
        return stringBuffer.toString();
    }

    public static final String getSpeedString(int n) {
        if (n != 0) {
            return String.format("%3.2f", Float.valueOf(49152.0f / (float)n));
        }
        return "";
    }
}

